#include "ScnGameDetails.h"
#include "ScnGames.h"


HRESULT CScnGameDetails::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	xmvPlayer = NULL;

	//char temp[1024];
    // Retrieve controls for later use.
    GetChildById( L"TitleText", &m_title );
    GetChildById( L"Genre", &m_genre );
    GetChildById( L"Cover", &m_cover );
    GetChildById( L"ScreenShot1", &m_ss1 );
    GetChildById( L"ScreenShot2", &m_ss2 );
    GetChildById( L"ScreenShot3", &m_ss3 );
    GetChildById( L"ScreenShot4", &m_ss4 );
    GetChildById( L"DescText", &m_desc );
    GetChildById( L"AButton", &m_abutton );
    GetChildById( L"Video", &m_video );
    GetChildById( L"VideoBack", &m_videoback );
    GetChildById( L"Background", &m_background );
    GetChildById( L"Date", &m_date );
    GetChildById( L"Time", &m_time );
    GetChildById( L"DateTime", &m_datetime );

	m_title.SetText(CurentGame->title.c_str());
	m_desc.SetText(CurentGame->desc.c_str());

	wstring genre;
	vector<wstring>::iterator itr;
	for (itr = CurentGame->genres.begin() ; itr != CurentGame->genres.end() ; itr++)
	{
		genre.append(*itr);
		genre.append(L" / ");
	}
	genre = genre.substr(0,genre.size() - 3);
	m_genre.SetText(genre.c_str());

	if (CurentGame->i_BoxArt)
	{
		m_cover.SetImagePath(CurentGame->boxart.c_str());
	} else {
		m_cover.SetImagePath(L"file://game:/media/boxart.png");
	}


	if (CurentGame->i_SSCount > 0)
	{		
		wstring ss1 = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/ss-1.jpg";
		//DebugMsg("Using ss1 %s",ss1.c_str());
		m_ss1.SetImagePath(ss1.c_str());
	} else {
		m_ss1.SetImagePath(L"file://game:/media/noss.png");
	}

	if (CurentGame->i_SSCount > 1)
	{		
		wstring ss2 = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/ss-2.jpg";
		//DebugMsg("Using ss1 %s",ss1.c_str());
		m_ss2.SetImagePath(ss2.c_str());
	} else {
		m_ss2.SetImagePath(L"file://game:/media/noss.png");
	}

	if (CurentGame->i_SSCount > 2)
	{		
		wstring ss3 = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/ss-3.jpg";
		//DebugMsg("Using ss1 %s",ss1.c_str());
		m_ss3.SetImagePath(ss3.c_str());
	} else {
		m_ss3.SetImagePath(L"file://game:/media/noss.png");
	}

	if (CurentGame->i_SSCount > 3)
	{		
		wstring ss4 = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/ss-4.jpg";
		//DebugMsg("Using ss1 %s",ss1.c_str());
		m_ss4.SetImagePath(ss4.c_str());
	} else {
		m_ss4.SetImagePath(L"file://game:/media/noss.png");
	}

	wstring preview = datapath + L"artwork\\" + CurentGame->imagefolder + L"\\preview.wmv";
	if (FileExists(preview))
	{
		m_video.SetShow(TRUE);
		m_videoback.SetShow(TRUE);

		if (xmvPlayer)
		{
			xmvPlayer->Release();
			xmvPlayer = NULL;
		}

		XMediaCreateXmvPlayerFromFile(pDevice,wstrtostr(preview).c_str(),&xmvPlayer);
		m_video.SetPlayer(xmvPlayer);
	} else {
		m_video.SetShow(FALSE);
		m_videoback.SetShow(FALSE);
	}

	wstring background = datapath + L"artwork\\" + CurentGame->imagefolder + L"\\background.jpg";
	if (FileExists(background))
	{
		wstring background_x = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/background.jpg";
		m_background.SetImagePath(background_x.c_str());
		m_background.SetShow(TRUE);
	} else {
		m_background.SetShow(FALSE);
	}

	SetClock(m_date,m_time,m_datetime);
	SetTimer(TM_CLOCK,1000);

	return S_OK;
}

HRESULT CScnGameDetails::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
    if ( hObjPressed == m_abutton )
    {
		cl.LaunchGame(CurentGame);
	}
	return S_OK;
}

HRESULT CScnGameDetails::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    switch( pTimer->nId )
    {
    case TM_CLOCK:
		SetClock(m_date,m_time,m_datetime);
		break;
	}
    bHandled = TRUE;
    return S_OK;
}

HRESULT CScnGameDetails::OnDestroy()
{
	if (xmvPlayer)
	{
		xmvPlayer->Release();
		xmvPlayer = NULL;
	}

	return S_OK;
}
